/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftFeatureConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class SmallTunnelStairs
extends BetterMineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 9;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 8;
    private static final int LOCAL_Z_END = 4;

    public SmallTunnelStairs(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_STAIRS, compoundTag);
    }

    public SmallTunnelStairs(int chunkPieceLen, Random random, BoundingBox blockBox, Direction direction, BetterMineshaftFeatureConfiguration config) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_STAIRS, chunkPieceLen, config, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)9, (int)5, (Direction)direction);
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_(), this.f_73383_.m_162396_() + 4, this.f_73383_.m_162398_() - 1, direction, this.f_73384_);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_(), this.f_73383_.m_162396_() + 4, this.f_73383_.m_162401_() + 1, direction, this.f_73384_);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_() + 4, this.f_73383_.m_162401_(), direction, this.f_73384_);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_() + 4, this.f_73383_.m_162398_(), direction, this.f_73384_);
            }
        }
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 1, 0, 4, 8, 4, this.config.blockStateRandomizers.mainRandomizer);
        this.chanceReplaceNonAir(world, box, random, this.config.replacementRate, 0, 0, 0, 4, 0, 4, this.config.blockStateRandomizers.floorRandomizer);
        for (int i = 0; i < 5; ++i) {
            this.fill(world, box, 1, i + 1, i, 3, i + 1 + 3, i, AIR);
            this.chanceReplaceNonAir(world, box, random, 0.5f, 1, i, i, 3, i, i, this.config.blockStateRandomizers.mainRandomizer);
            this.replaceAirOrChains(world, box, 1, i, i, 3, i, i, this.config.blockStates.mainBlockState);
            if (i == 0) {
                this.chanceReplaceAir(world, random, 0.5f, (BlockState)((BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PoweredRailBlock.f_55214_, (Comparable)RailShape.ASCENDING_NORTH), 2, i + 1, i, box);
                continue;
            }
            if (i == 4) {
                this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.NORTH_SOUTH), 2, i + 1, i, box);
                continue;
            }
            this.chanceReplaceAir(world, random, 0.5f, (BlockState)Blocks.f_50156_.m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)RailShape.ASCENDING_NORTH), 2, i + 1, i, box);
        }
        this.addBiomeDecorations(world, box, random, 1, 0, 0, 3, 7, 4);
        this.addVines(world, box, random, this.config.decorationChances.vineChance, 1, 0, 1, 3, 8, 3);
    }
}

